unit Find_pgm;

interface

uses
  wsc, mio, DisplayUnit,
  SysUtils, WinTypes, WinProcs, Messages,
  Classes, Graphics, Controls,
  Forms, Dialogs, Menus, StdCtrls;

type
  TFind = class(TForm)
    MainMenu: TMainMenu;
    FindModem: TMenuItem;
    Exit: TMenuItem;
    Memo: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure ExitClick(Sender: TObject);
    procedure FindModemClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Find: TFind;

implementation

{$R *.DFM}

procedure TFind.FormCreate(Sender: TObject);
begin
  DisplayLine(Memo,'*** Connect your modem to this computer and turn to ON.');
  DisplayLine(Memo,'*** Select FindModem above to search for your modem.');
end;

procedure TFind.ExitClick(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TFind.FindModemClick(Sender: TObject);
var
  Port  : Integer;
  Code  : Integer;
  First : Integer;
  Last  : Integer;
  Text  : String;
  Ptr   : PChar;
begin
   First := COM1;
   Last := COM4;
   DisplayLine(Memo,'');
   for Port := First to Last do
     begin
       DisplayString(Memo, Format('*** Examining COM%d: ',[1+Port]));
       Code := SioReset(Port,128,128);
       if Code<0 then DisplayError(Memo,Code)
       else
         begin
           (* turn on DTR or modem won't respond *)
           Code := SioDTR(Port,'S');
           (* modem should raise DSR *)
           if SioDSR(Port) > 0 then
             begin
               DisplayLine(Memo,'Port is found (DSR = 1)');
               GetMem(Ptr,32);
               Text := '!!AT!';
               StrPCopy(Ptr,Text);
               (* send AT *)
               DisplayLine(Memo,'Sending AT');
               mioSendTo(Port,200,Ptr);
               repeat
                 Code := mioDriver(Port);
                 if(Code>=0) then DisplayChar(Memo,Chr(Code))
               until Code = MIO_IDLE;
               (* wait for OK *)
               Text := 'OK';
               StrPCopy(Ptr,Text);
               DisplayLine(Memo,'Waiting for OK . . .');
               mioWaitFor(Port,2000,Ptr);
               repeat
                 Code := mioDriver(Port);
                 if Code>=0 then DisplayChar(Memo,Chr(Code))
               until Code = MIO_IDLE;
               FreeMem(Ptr,32);
               (* did we get OK ? *)
               if mioResult(Port) <> 0 then
                 begin
                   DisplayLine(Memo,'');
                   DisplayLine(Memo,
                     Format('Modem detected on COM%d',[1+Port]));
                   (*break*)
                 end
               else DisplayLine(Memo,'No response.')
             end
           else DisplayLine(Memo,'Port is found (DSR = 0)');
           SioDone(Port);
         end
     end
end;

end.
